IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'EST_PROD_REM_PRE_VENC_REFATORACAO_BKP')  AND type in (N'U')) 
BEGIN
	DROP TABLE EST_PROD_REM_PRE_VENC_REFATORACAO_BKP
	PRINT 'DROP EST_PROD_REM_PRE_VENC_REFATORACAO_BKP'
END 

IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'EST_PROD_REM_PRE_VENC')  AND type in (N'U')) 
BEGIN
	SELECT * INTO EST_PROD_REM_PRE_VENC_REFATORACAO_BKP FROM EST_PROD_REM_PRE_VENC
		PRINT 'CRIADA TABELA EST_PROD_REM_PRE_VENC_REFATORACAO_BKP'
END 

IF NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME='EST_PROD_REM_PRE_VENC' AND COLUMN_NAME='DT_ENV_REM')
BEGIN
	ALTER TABLE EST_PROD_REM_PRE_VENC_REFATORACAO_BKP ADD DT_ENV_REM DATETIME NOT NULL DEFAULT ''
END

IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'EST_PROD_REM_PRE_VENC_REFATORACAO_BKP')  AND type in (N'U')) 
BEGIN
	IF ((SELECT COUNT (*) FROM EST_PROD_REM_PRE_VENC_REFATORACAO_BKP) = (SELECT COUNT(*) FROM EST_PROD_REM_PRE_VENC))
	BEGIN
			DROP TABLE EST_PROD_REM_PRE_VENC;
			PRINT 'DROP EST_PROD_REM_PRE_VENC'
	END
END 

IF  NOT EXISTS (SELECT 1 FROM sys.objects 	WHERE object_id = OBJECT_ID(N'EST_PROD_REM_PRE_VENC') 	AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[EST_PROD_REM_PRE_VENC](
	[CD_EMP] [int] NOT NULL,
	[CD_REMESSA] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[DS_REMESSA] [varchar](200) NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[CD_USU_CAD] [int] NOT NULL,
	[DT_ULT_ALT] [datetime] NULL,
	[DT_ENV_REM] [datetime] NOT NULL,
	[CD_USU_ULT_ALT] [int] NULL,
	[STS_REMESSA] [int] NOT NULL
 CONSTRAINT [PK_EST_PROD_REM_PRE_VENC] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_REMESSA] ASC,
	[CD_FILIAL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

	PRINT 'CRIADO TABELA EST_PROD_REM_PRE_VENC, CRIANDO CONSTRAINTS'

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC] ADD  CONSTRAINT [DF_EST_PROD_REM_PRE_VENC_DS_REMESSA]  DEFAULT ('') FOR [DS_REMESSA]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC] ADD  CONSTRAINT [DF_EST_PROD_REM_PRE_VENC_DT_CAD]  DEFAULT ('') FOR [DT_CAD]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC] ADD  CONSTRAINT [DF_EST_PROD_REM_PRE_VENC_STS_REMESSA]  DEFAULT ((0)) FOR [STS_REMESSA]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_REM_PRE_VENC_GLB_USU] FOREIGN KEY([CD_USU_CAD])
REFERENCES [dbo].[GLB_USU] ([CD_USU])

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC] CHECK CONSTRAINT [FK_EST_PROD_REM_PRE_VENC_GLB_USU]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_REM_PRE_VENC_PRC_EMP] FOREIGN KEY([CD_EMP])
REFERENCES [dbo].[PRC_EMP] ([CD_EMP])

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC] CHECK CONSTRAINT [FK_EST_PROD_REM_PRE_VENC_PRC_EMP]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_REM_PRE_VENC_PRC_FILIAL] FOREIGN KEY([CD_EMP], [CD_FILIAL])
REFERENCES [dbo].[PRC_FILIAL] ([CD_EMP], [CD_FILIAL])

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC] CHECK CONSTRAINT [FK_EST_PROD_REM_PRE_VENC_PRC_FILIAL]
END

IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'EST_PROD_REM_PRE_VENC')  AND type in (N'U')) 
BEGIN
	PRINT 'IMPORTANDO DADOS DA TABELA DE BACKUP'
	INSERT INTO EST_PROD_REM_PRE_VENC  (CD_EMP, CD_REMESSA, CD_FILIAL, DS_REMESSA, DT_CAD, CD_USU_CAD, DT_ULT_ALT, DT_ENV_REM, CD_USU_ULT_ALT, STS_REMESSA)
		SELECT CD_EMP, CD_REMESSA, CD_FILIAL, DS_REMESSA, DT_CAD, CD_USU_CAD, DT_ULT_ALT, DT_ENV_REM, CD_USU_ULT_ALT, STS_REMESSA FROM EST_PROD_REM_PRE_VENC_REFATORACAO_BKP
		--SELECT CD_EMP, CD_REMESSA, CD_FILIAL, DS_REMESSA, DT_CAD, CD_USU_CAD, DT_ULT_ALT, DT_ENV_REM, CD_USU_ULT_ALT, STS_REMESSA FROM  [EST_PROD_REM_PRE_VENC]
	PRINT 'FINALIZADO IMPORTACAO DE DADOS DA TABELA DE BACKUP'
END 


